/*
  But :     Controlleur
  Auteur : Adrien + Risse
  Date :   25.05.2021 / V1.0
*/


/*
 * 1. DOM PRET : DEMARRAGE DE L'APPLICATION
 */
document.onreadystatechange = function () {
  if (document.readyState === "complete") {
    _afficherPersonnes();
  }
};


/*
 * 2. METHODES PRIVEES DE LECTURE/ECRITURE DANS LA VUE
 */

// affiche la liste des données au bas de la vue (avec du HTML généré)
function _afficherPersonnes() {
  let txt = "<ul>";
  for (i = 0; i < personnes.length; i++) {
    txt += '<li><a href="#" onclick="ctrl.selectionner(' + i + ');">' +
      personnes[i] + ' </a></li>';

  }
  txt += "</ul>";
  document.getElementById("info").innerHTML = txt;
}

// affiche les infos d'une personne dans le formulaire
function _afficherInfosPersonne(p) {
  document.getElementById("prenom").value = p.prenom;
  document.getElementById("nom").value = p.nom;
  document.getElementById("age").value = p.age;
}

// lit le contenu des masques de saisie pour en faire une personne
function _lireInfosPersonne() {
  let p = null;
  let prenom = document.getElementById("prenom").value;
  let nom = document.getElementById("nom").value;
  let age = document.getElementById("age").value;
  if (prenom.length > 0 && nom.length > 0 && age.length > 0) {
    p = new Personne(prenom, nom, age);
  }
  return p;
}

/*
 * 3. METHODES PUBLIQUES NECESSAIRES A LA VUE
 */

// appelée depuis la vue pour afficher les données de la personne sélectionnné
function selectionnerPersonne(i) {
  _afficherInfosPersonne(personnes[i]);
}

// appelée depuis la vue pour ajouter une personne
function ajouter() {
  let p = _lireInfosPersonne();
  ajouterPersonne(p);
  _afficherPersonnes();
}

// appelée depuis la vue pour supprimer une personne
function supprimer() {
  let p = _lireInfosPersonne();
  if (p != null) {
    supprimerPersonne(p);
    _afficherPersonnes();
  }

}

