/*
  But :   classe  Worker 
  Auteur : Adrien + Risse
  Date :   30.05.2021 / V1.0
*/


class Worker {

    constructor() {
        this.personnes = [
            new Personne("John", "Doe", 44),
            new Personne("Anna", "Smith", 32),
            new Personne("Peter", "Jones", 29)
        ];

        this.personnes.sort();
    }


    // fonction privée pour retrouver l'index d'une personne dans le tableau, -1 autrement
    // il faut comparer avec toString()
    _trouverPersonne(p) {
        let idx = -1;
        if (p != null) {
            for (let i = 0; i < this.personnes.length; i++) {
                let pers = this.personnes[i];
                if (pers.age === p.age && pers.nom === p.nom && pers.prenom === p.prenom) {
                    idx = i;
                }
            }
        }
        return idx;
    }

    // ajouter une personne dans la liste des personnes si pas trouvée
    ajouterPersonne(p) {
        if (this._trouverPersonne(p) === -1) {
            this.personnes.push(p);
        }
    }

    // supprimer une personne dans la liste des personnes si trouvée
    supprimerPersonne(p) {
        let idx = this._trouverPersonne(p);
        if (idx != -1) {
            this.personnes.splice(idx, 1);
        }
    }
}