/*
  But :    Page javaScript qui permet de la communication entre les pages
  Auteur : Adrien Risse
  Date :   31.05.2021 / V1.0
*/
var httpServ = (function () {

  function _centraliserErreurHttp(httpErrorCallbackFn) {
    $.ajaxSetup({
      error: function (jqXHR, exception) {
        let msg;
        if (jqXHR.status === 0) {
          msg = "Pas d'accès à la ressource serveur demandée !";
        } else if (jqXHR.status === 404) {
          msg = "Page demandée non trouvée [404] !";
        } else if (jqXHR.status === 500) {
          msg = "Erreur interne sur le serveur [500] !";
        } else if (exception === 'parsererror') {
          msg = "Erreur de parcours dans le JSON !";
        } else if (exception === 'timeout') {
          msg = "Erreur de délai dépassé [Time out] !";
        } else if (exception === 'abort') {
          msg = "Requête Ajax stoppée !";
        } else {
          msg = "Erreur inconnue : \n" + jqXHR.responseText;
        }
        httpErrorCallbackFn(msg);
      }
    });
  }

  function _envoyerRequete(nomService, valeur, successCallback) {
    let url = "php/POST.php";
    let param = "Temperature=" + valeur;

    // suivant le type de copnversion, on modifie la requête
    if (nomService === "CelsiusToFahrenheit") {
      param += "&FromUnit=C&ToUnit=F";
    } else {
      param += "&FromUnit=F&ToUnit=C";
    }

    // envoi de la requête
    $.ajax(url, {
      type: "POST",
      contentType: "application/x-www-form-urlencoded; charset=UTF-8",
      data: param,
      success: successCallback
    });
  }

  function _convertirCF(valeur, successCallback) {
    _envoyerRequete("CelsiusToFahrenheit", valeur, successCallback);
  }

  function _convertirFC(valeur, successCallback) {
    _envoyerRequete("FahrenheitToCelsius", valeur, successCallback);
  }

  // définition des noms de méthodes publiques (à gauche)
  return {
    centraliserErreurHttp: _centraliserErreurHttp,
    convertirCelsiusVersFahrenheit: _convertirCF,
    convertirFahrenheitVersCelsius: _convertirFC
  };

})();
