/*
 * Couche de services HTTP (worker). Comme un objet Java,
 * mais créé avec une "closure" exécutée immédiatement (IIFE).
 * Permet de rendre privées ou publiques certaines fonctions.
 *
 * @author Adrien Risse
 */
class HttpServ {
  constructor() {}

  centraliserErreurHttp(httpErrorCallbackFn) {
    $.ajaxSetup({
      error: function (xhr, exception) {
        let msg;
        if (xhr.status === 0) {
          msg = "Pas d'accès à la ressource serveur demandée !";
        } else if (xhr.status === 404) {
          msg = "Page demandée non trouvée [404] !";
        } else if (xhr.status === 500) {
          msg = "Erreur interne sur le serveur [500] !";
        } else if (exception === "parsererror") {
          msg = "Erreur de parcours dans le JSON !";
        } else if (exception === "timeout") {
          msg = "Erreur de délai dépassé [Time out] !";
        } else if (exception === "abort") {
          msg = "Requête Ajax stoppée !";
        } else {
          msg = "Erreur inconnue : \n" + xhr.responseText;
        }
        httpErrorCallbackFn(msg);
      },
    });
  }

  celcius2Fahrenheit(degres, successCallback) {
    let url = "php/POST.php";
    let param = "Temperature=" + degres + "&FromUnit=C&ToUnit=F";

    // envoi de la requête
    $.ajax(url, {
      type: "POST",
      contentType: "application/x-www-form-urlencoded; charset=UTF-8",
      data: param,
      success: successCallback,
    });
  }

  fahrenheit2Celcius(degres, successCallback) {
    let url = "php/GET.php";
    let param = "&Temperature=" + degres + "&FromUnit=F&ToUnit=C";

    // envoi de la requête
    $.ajax(url, {
      type: "GET",
      data: param,
      success: successCallback
    });
  }

  // celcius2Fahrenheit(degres, successCallback, errorCallback) {
  //   let url = "http://mettrauxpa.emf-informatique.ch/convert_temp_p_xml1.php";
  //   let param = "Temperature=" + degres + "&FromUnit=C&ToUnit=F";

  // // envoi de la requête
  // $.ajax(url, {
  //   type: "POST",
  //   contentType: "application/x-www-form-urlencoded; charset=UTF-8",
  //   data: param,
  //   success: successCallback,
  //   error: errorCallback
  // });
  // }

  // celcius2Fahrenheit(valeur, successCallback) {
  //   this.envoyerRequete("CelsiusToFahrenheit", valeur, successCallback);
  // }

  // Fahrenheit2Celcius(valeur, successCallback) {
  //   this.envoyerRequete("FahrenheitToCelsius", valeur, successCallback);
  // }
}
